//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.CodeDom.Compiler;

namespace CodeDomHelloWorld
{
	/// <summary>
	/// Podsumowanie dla CodeDomHelloWorldMain.
	/// </summary>
	class Compiler
	{
		public static void CompileAndRun(CodeDomProvider provider, string source, string target)
		{
			// Uycie interfejsu CodeProvider
			CompilerParameters param = new CompilerParameters(null, target, true);
			param.GenerateExecutable = true;
			ICodeCompiler cc = provider.CreateCompiler();
			CompilerResults cr = cc.CompileAssemblyFromSource(param, source);
			System.Collections.Specialized.StringCollection output = cr.Output;
			foreach(string s in output)
			{
				Console.WriteLine(s);
			}

			if(cr.Errors.Count != 0)
			{
				CompilerErrorCollection es = cr.Errors;
				foreach(System.CodeDom.Compiler.CompilerError e in es)
				{
					Console.WriteLine(e.ToString());
				}
			}
			else
			{
				// Ustawienie ApplicationBase na aktualny katalog
				AppDomainSetup info = new AppDomainSetup();
				info.ApplicationBase = "file:\\\\" + System.Environment.CurrentDirectory;
				// Utworzenie domeny aplikacji z pustym dowodem
				AppDomain dom = AppDomain.CreateDomain("HelloWorld", null, info);
				dom.ExecuteAssembly(target);
				// Oczyszczenie poprzez usunicie domeny aplikacji z pamici
				AppDomain.Unload(dom);  
			}
		}
	}
}